function test_suite = testCheckParens %#ok<STOUT>
initTestSuite;

function testNullInput
out = callCheckParens('[]');
assertEqual(out.Value,'[]');

function testEmptyParens
out = callCheckParens('()');
assertEqual(out.Value,'()')

function testCharInput %#ok<*DEFNU>
out = callCheckParens('s');
assertEqual(out.Value,'s');

function testAddition
out = callCheckParens('s+t');
assertEqual(out.Value,'(s+t)');

function testAdditionWithParens
out = callCheckParens('(s+t)');
assertEqual(out.Value,'(s+t)');

function testSubtraction
out = callCheckParens('s-t');
assertEqual(out.Value,'(s-t)');

function testSubtractionWithParens
out = callCheckParens('(s-t)');
assertEqual(out.Value,'(s-t)');

function testMixedExpression
out = callCheckParens('s*t+1');
assertEqual(out.Value,'(s*t+1)');

function testNestedParens
out = callCheckParens('s+(t+u)');
assertEqual(out.Value,'(s+(t+u))');

function testUnbalancedParens
f = @() callCheckParens('((0)');
assertExceptionThrown(f,'polysym:polysym:unbalanceParens')